function [ok]=udp_capture_start(skt, type)
%function [ok]=udp_capture_start(skt, type)
% Start a capture of udp commands to a microcontroller
% type
% 'c'  .c file capture
% 'b'  .bin file capture (default)

% The script will signal that a capture is in progress by creating either
% 'ConfigLogType.bin' or 'ConfigLogType.c' after attempting to delete both
% The script will then create either 'ConfigLog.c' or 'ConfigLog.bin' as appropriate
% see config_write.m for details of file formats
% The script will turn off any existing AutoStart and reset the microcontroller to ensure a clean start
% see also udp_put_startup.m config_write.m udp_capture_start.m udp_capture_stop.m AutoConfExample.m
% V1.0 Ian Stothers 10 May 2023
ok=0;
if (exist('type')!=1) type='b'; end;
if (exist('ConfigLog.c')==2) delete( 'ConfigLog.c'); end
if (exist('ConfigLog.bin')==2) delete( 'ConfigLog.bin'); end
if (exist('ConfigLogType.c')==2)delete( 'ConfigLogType.c'); end
if (exist('ConfigLogType.bin')==2)delete( 'ConfigLogType.bin'); end

if(exist('skt')==0)
   skt=sktopen('192.168.1.4');
endif
if (ischar(skt))
  skt=sktopen(skt);
endif

udpset(skt,'AutoStart',0);
udpprogconfig(skt);
udpreset(skt);
pause(5);
if (type=='c')
  fh=fopen('ConfigLog.c','w');
  fclose(fh);
  fh=fopen('ConfigLogType.c','w');
  fclose(fh);
else
  fh=fopen('ConfigLog.bin','w');
  fclose(fh);
  fh=fopen('ConfigLogType.bin','w');
  fclose(fh);
end
ok=1;

